<?php

    require_once( '../wp-config.php' );

	class Conexion{
	    
        private $mysqli = null;
		private $usuario = DB_USER;
		private $clave = DB_PASSWORD;
		private $server = DB_HOST;
		private $db = DB_NAME;
		private $prepared_query = null;

		public function conectar(){
			$this->mysqli = new mysqli($this->server, $this->usuario, $this->clave, $this->db);
			$this->mysqli->set_charset("utf8");

			if($this->mysqli->connect_errno){
				echo 'Falló al conectarse con MySQL: ' . $this->mysqli->connect_error;
			}
		}

		/* Devuelve el objeto consulta de un query
		 *
		 */
		public function query($consulta){
			return $this->mysqli->query($consulta);
		}

		/* Devuelve el número de rows que son afectados por la consulta.
		 * 'SELECT ''
		 * mysql_num_rows counts how many rows your SELECT statement found.
		 */
		public function verificarConsulta($consulta){
			return mysqli_num_rows($this->query($consulta));
		}

		/* Devuelve el número de rows que son afectados por 
		 *	registro o update.
		 * mysql_affect_rows counts on how many rows your 
		 *	INSERT, UPDATE, REPLACE or DELETE query was used. 
		 */
		public function verificarRegistro($consulta){
			$this->query($consulta);
			return mysqli_affected_rows($this->mysqli);
		}

		/* Transforma el objeto query a un arreglo de información.
		 *
		 */
		public function consultaArreglo($consulta){
			return mysqli_fetch_array($this->query($consulta));
		}

		public function consultaArregloAssoc($consulta){
			return mysqli_fetch_assoc($this->query($consulta));
		}

		public function cerrar(){
			$this->mysqli->close();
		}

		public function salvar($des){
			$string = $this->mysqli->real_escape_string($des);

			return $string;
		}

		public function filtrar($string){
			$res = $this->salvar($string);

			$buscar = array('á', 'é', 'í', 'ó', 'ú', 'Á', 'É', 'Í', 'Ó', 'Ú', 'ñ', 'Ñ');
			$reemplazar = array('&aacute','&eacute', '&iacute', '&oacute', '&uacute', '&Aacute', '&Eacute', '&Iacute', '&Oacute', '&Uacute', '&ntilde', '&Ntilde');
			$res = str_replace($buscar, $reemplazar, $string);
			$res = strtolower($res);
			$res = trim($res);

			return $res;
		}

		public function rescatar($string){
			$buscar = array('&aacute','&eacute', '&iacute', '&oacute', '&uacute', '&Aacute', '&Eacute', '&Iacute', '&Oacute', '&Uacute', '&ntilde', '&Ntilde');
            $reemplazar = array('á', 'é', 'í', 'ó', 'ú', 'Á', 'É', 'Í', 'Ó', 'Ú', 'ñ', 'Ñ');

            $res = str_replace($buscar, $reemplazar, $string);

            return $res;
		}

		//http://guid.us/GUID/PHP
		//Its easy to make GUIDs in PHP. Below is clean code using windows COM to get GUIDs. When the PHP creates GUIDs or UUIDs they are V4 guids.
		//v1
		/*public function getGUID(){
		    if (function_exists('com_create_guid')){
		        return com_create_guid();
		    }else{
		        mt_srand((double)microtime()*10000);//optional for php 4.2.0 and up.
		        $charid = strtoupper(md5(uniqid(rand(), true)));
		        $hyphen = chr(45);// "-"
		        /*$uuid = chr(123)// "{"
		            .substr($charid, 0, 8).$hyphen
		            .substr($charid, 8, 4).$hyphen
		            .substr($charid,12, 4).$hyphen
		            .substr($charid,16, 4).$hyphen
		            .substr($charid,20,12)
		            .chr(125);// "}"*//*
		        $uuid = substr($charid, 0, 8).$hyphen
		            .substr($charid, 8, 4).$hyphen
		            .substr($charid,12, 4).$hyphen
		            .substr($charid,16, 4).$hyphen
		            .substr($charid,20,12);
		        return $uuid;
		    }
		}*/
		function getGUID(){
	    if (function_exists('com_create_guid')){
	        return com_create_guid();
	    }else{
	        //$seed = (int)(microtime()*10000);
	        //mt_srand($seed); //optional for php 4.2.0 and up.
	        $seed = openssl_random_pseudo_bytes(4);
	        mt_srand(unpack('l', $seed)[1]);
	        $charid = strtoupper(hash('sha256', uniqid(random_bytes(16), true)));
	        $hyphen = chr(45); // "-"
	        $uuid = substr($charid, 0, 8).$hyphen
	            .substr($charid, 8, 4).$hyphen
	            .substr($charid,12, 4).$hyphen
	            .substr($charid,16, 4).$hyphen
	            .substr($charid,20,12);
	        return $uuid;
	    }
	}

		/*Codifica un string a utf8*/
		public function codeToUtf8($string){
			$utf8String = iconv(mb_detect_encoding($string, mb_detect_order(), true), "UTF-8", $string);

			return $utf8String;
		}
		
		
		/******************************************************************/
		/******************************************************************/
		/**********************PREPARED STATEMENST*************************/
		/******************************************************************/
		
		public function prepararConsulta($consulta)
		{
		    $this->prepared_query = mysqli_prepare($this->mysqli, $consulta);
		}
		
		public function bindingRecuperacion($email)
		{
		    mysqli_stmt_bind_param($this->prepared_query, "s", $email);
		}
		
		public function bindingLogin($email)
		{
		    mysqli_stmt_bind_param($this->prepared_query, "s", $email);
		}
		
		public function bindingRegistration($name, $ap_paterno, $email, $password, $brands)
		{
		    mysqli_stmt_bind_param($this->prepared_query, "ssssd", $name, $ap_paterno, $email, $password, $brands);
		}
		
		public function executePrepared()
		{
		    mysqli_stmt_execute($this->prepared_query);
		    return mysqli_stmt_get_result($this->prepared_query);
		}
		
		public function verificarPreparedStatement()
		{
		    return mysqli_num_rows($this->executePrepared());
		}
		
		public function verificarPreparedInsert()
		{
		    return mysqli_stmt_execute($this->prepared_query);
		}
		
	    public function arregloPreparedStatement()
	    {
	        return mysqli_fetch_array($this->executePrepared());
	    }

	}

?>
