<?php 

	//function validRegisData($name, $ap_paterno, $ap_materno, $birthday, $issn, $email, $password)
	function validRegisData($name, $ap_paterno, $email, $password, $confirm, $dterms)
	{
		$validation = 0;

		$validation += validName($name);
		$validation += validName($ap_paterno);
		$validation += validEmail($email);
		$validation += validPass($password);
		$validation += validConfirm($password, $confirm);
		$validation += validNumero($dterms);
		
		return $validation;
	}

	function getLabelErr($name, $ap_paterno, $email, $password, $confirm, $dterms)
	{
		$err_msg = '';
		$err_id = '!#r_reg_div?Datos Faltantes:';

		if(validName($name)){
			$err_msg .= '!#r_name_div?Formato nombre inválido';
			$err_id .= '<br>Nombre';
		}
		if(validName($ap_paterno)){
			$err_msg .= '!#r_app_div?Formato apellido paterno inválido';
			$err_id .= '<br>Apellido Paterno';
		}
		if(validEmail($email)){
			$err_msg .= '!#r_email_div?Ingrese un correo electrónico válido';
			$err_id .= '<br>Correo electrónico';
		}
		if(validPass($password)){
			$err_msg .= '!#r_pass_div?Formato Password: <br>Almenos 8 letras y/o digitos, <br>Al menos 1 letra mayúscula, <br>Al menos 1 letra minúscula, <br>Al menos 1 número. <br>(Opcional) Caracteres especiales permitidos: _@#$%^&- ';
			$err_id .= '<br>Password';
		}
		if(!validPass($password) && validConfirm($password, $confirm)){
			$err_msg .= '!#r_conf_div?Las contraseñas no coinciden, verificar.';
			$err_id .= '<br>Password';
		}
		if(validNumero($dterms)){
			$err_msg .= '!#r_reg_div?"';
			$err_id .= '<br>Formato de Dato Inválido en checkbox "no deseo recibir promociones';
		}

		return $err_msg. $err_id;
	}
	
	/********************************************/
	
	function validName($name)
	{
		$regex = "/^[\p{L}\s]{1,}$/u";

		$validName = stringFormat($name);

		if (preg_match($regex, $validName))
		{
			return 0;
		} 
		else
		{
			return 1;
		}
	}

	/* Registration module */
	function validPass($pass)
	{
		$validPass = stringFormat($pass);
		
		$regex4 = "/^((?=(.*\d){1,})(?=.*[a-z])(?=.*[A-Z])(?=(.*[!@#$%^&]){0,}).{8,})$/";

	     if (preg_match($regex4, $validPass)) 
	    {
			return 0;
		}
		else
		{
			return 1;
		}
	}

	// return 0 for $pass == $confirm
	function validConfirm($pass, $confirm)
	{
		$validPass = stringFormat($pass);
		$validConf = stringFormat($confirm);	
		
	    if (!strcmp($validPass, $validConf)) 
	    {
			return 0;
		}
		else
		{
			return 1;
		}
	}



	/********************************************/


	//id_precio, model
	function validNumero($num)
	{
		$regex = "/^[\d]{1,}$/u";

		$validNum = stringFormat($num);

		if (preg_match($regex, $validNum))
		{
			return 0;
		} 
		else
		{
		    if($validNum == 0)
		    {
		        return 0;
		    }
		    else
		    {
			    return 1;
		    }
		}
	}


	/********************************************/



	function validLogin($email, $key)
	{
		$validation = 0;

		$validation += validEmail($email);
		$validation += validPassword($key);

		return $validation;
	}

	function validEmail($email)
	{
		$validEmail = stringFormat($email);

		if(filter_var($validEmail, FILTER_VALIDATE_EMAIL))
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}

	/* Login module */
	function validPassword($pass)
	{
		$pass_l = strlen($pass);

		//if($pass_l >= 8)
		if($pass_l >= 1)
		{
			return 0;
		}
		else
		{
			return 1;
		}
	}



	function stringFormat($string)
	{
		$utf8_string = codeToUtf8($string);
		$utf8_string = trim($utf8_string);

		return $utf8_string;
	}

    function mb_escape($string) 
    {
        //return mb_ereg_replace('[\x00\x0A\x0D\x1A\x22\x25\x27\x5C\x5F]', '\\\0', $string);
        return mb_ereg_replace('[\x00\x0A\x0D\x1A\x22\x25\x27\x5C\x5F]', '', $string);
        //\x00 Null
        //\x0A LF Line feed (nueva línea)
        //\x0D CR Car return
        //\x1A Sub Substitution
        //\x22 " quotation marks
        //\x25 % percent sign
        //\x27 ' single quote
        //\x5C \ backslash
        //\x5F _ underscore
    }

    function codeToUtf8($string){
        $utf8String = iconv(mb_detect_encoding($string, mb_detect_order(), true), "UTF-8", $string);

        return $utf8String;
    }

    /* TRIM PROPERTIES trim() rtrim() ltrim()
     * These functions will remove the following whitespace characters: 
     * " " (an ordinary space)
     * "\t" (a tab)
     * "\n" (a new line)
     * "\r" (a carriage return)
     * "\0" (the NUL-byte)
     * "\x0B" (a vertical tab)
     *
     *
     * https://www.techfry.com/php-tutorial/how-to-remove-whitespace-characters-in-a-string-in-php-trim-function
     */

?>
