<?php 
    error_reporting(E_ALL);
    ini_set('display_errors', '1');

	include_once $_SERVER['DOCUMENT_ROOT'].'/controller/validations.php';	
	
	$SANITIZED_POST = sanitizarEntrada($_POST);
	
	if(!isset($SANITIZED_POST['controller']) || empty($SANITIZED_POST['controller'])){
		echo 'error_0';
	}else{
		$controller = $SANITIZED_POST['controller'];

		switch($controller){
		    case "login" : 
				exLogin($SANITIZED_POST['email_php'], $SANITIZED_POST['key_php']);
				break;
			case str_replace("_","&lowbar;","n_user"):
				usrRegistration($SANITIZED_POST['name'], $SANITIZED_POST['ap_paterno'], $SANITIZED_POST['email'], $SANITIZED_POST['password'], $SANITIZED_POST['confirm'], $SANITIZED_POST['aterms'], $SANITIZED_POST['dterms']);
				break;
			case "recover" :
				exRecovery($SANITIZED_POST['email_php']);
				break;
		}

	}
	
	function exLogin($email, $key)
	{
		//$err_msg = '||-1||#r_login_div||Datos incorrectos, verificar credenciales.';
		$err_msg = json_encode(
		    array(
		        "data-desc"=>htmlentities("error_1", ENT_QUOTES, 'utf-8' ), 
		        "data-op"=>htmlentities("-1", ENT_QUOTES, 'utf-8' ), 
		        "data-element"=>htmlentities("#r_login_div", ENT_QUOTES, 'utf-8' ), 
		        "data-resp"=>htmlentities("Datos incorrectos, verificar credenciales.", ENT_QUOTES, 'utf-8' )
	        )
	    );

		if(validLogin($email, $key) == 0)
		{
			$utf8_mail = stringFormat($email);
			$utf8_mail = stringFormat($key);

			if(is_null($email) || is_null($key))
			{
				echo $err_msg;
			}
			else
			{	
				include_once $_SERVER['DOCUMENT_ROOT'].'/model/usuario.php';

				$usuario = new Usuario();
				$usuario->login($email, $key); 
			}
		}
		else
		{
			echo $err_msg;
		}
	}
	
	/*function usrRegistration($name, $ap_paterno, $email, $password, $confirm, $aterms, $dterms)
	{
		$err_msg = '||-1||#r_reg_div?Verificar Datos Faltantes.';
		//$captcha_err = '||-1||#r_reg_div?Completar captcha'; 
		
		/*$secret = '6Ld25qYZAAAAAFW7dhtzLNv3sndu3yRQjsSvL0N6';
		$response = $captcha;

		$verify=file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret={$secret}&response={$response}");
		$captcha_success=json_decode($verify);*//*
		if(validNumero($aterms) == 0 && $aterms == 1)
		{

    		if(validRegisData($name, $ap_paterno, $email, $password, $confirm, $dterms) == 0)
    		{
    			$utf8_name = ucwords(strtolower(stringFormat($name)));
    			$utf8_ap = ucwords(strtolower(stringFormat($ap_paterno)));
    			$utf8_email = strtolower(stringFormat($email));
    			$utf8_pass = stringFormat($password);
    			$utf8_dterms = stringFormat($dterms);
    
    			//echo $utf8_name . '-' . $utf8_ap . '-' . $utf8_email . '-' . $utf8_pass;
    
    			if(!is_null($utf8_name) && !is_null($utf8_ap) && !is_null($utf8_email) && !is_null($utf8_pass) && !is_null($utf8_dterms))
    			{
    					include_once $_SERVER['DOCUMENT_ROOT'].'/model/usuario.php';
    
    					$usuario = new Usuario();
    					$usuario->usrRegistration($utf8_name, $utf8_ap, $utf8_email, $utf8_pass, $utf8_dterms);
    			}
    		}
    		else
    		{
    			$lbl_msg = getLabelErr($name, $ap_paterno, $email, $password, $confirm, $dterms);
    
    			echo $err_msg . $lbl_msg;
    		}
		}
		else
		{
		    echo '||-1||#r_reg_div?Aceptar Aviso de Privacidad.';    
		}
	}*/
	
	function usrRegistration($name, $ap_paterno, $email, $password, $confirm, $aterms, $dterms)
	{
		$err_msg = '||-1||#r_reg_div?Verificar Datos Faltantes.';
		
		if(validNumero($aterms) == 0 && $aterms == 1)
		{

    		if(validRegisData($name, $ap_paterno, $email, $password, $confirm, $dterms) == 0)
    		{
    			$utf8_name = ucwords(strtolower(stringFormat($name)));
    			$utf8_ap = ucwords(strtolower(stringFormat($ap_paterno)));
    			$utf8_email = strtolower(stringFormat($email));
    			$utf8_pass = stringFormat($password);
    			$utf8_dterms = stringFormat($dterms);
    
    			if(!is_null($utf8_name) && !is_null($utf8_ap) && !is_null($utf8_email) && !is_null($utf8_pass) && !is_null($utf8_dterms))
    			{
    					include_once $_SERVER['DOCUMENT_ROOT'].'/model/usuario.php';
    
    					$usuario = new Usuario();
    					$usuario->usrRegistration($utf8_name, $utf8_ap, $utf8_email, $utf8_pass, $utf8_dterms);
    			}
    		}
    		else
    		{
    		    $lbl_msg = '';
        		$err_id = '!#r_reg_div?Datos Faltantes:';
        
        		if(validName($name)){
        			$lbl_msg .= '!#r_name_div?Formato nombre inválido';
        			$err_id .= '<br>Nombre';
        		}
        		if(validName($ap_paterno)){
        			$lbl_msg .= '!#r_app_div?Formato apellido paterno inválido';
        			$err_id .= '<br>Apellido Paterno';
        		}
        		if(validEmail($email)){
        			$lbl_msg .= '!#r_email_div?Ingrese un correo electrónico válido';
        			$err_id .= '<br>Correo electrónico';
        		}
        		if(validPass($password)){
        			$lbl_msg .= '!#r_pass_div?Formato Password: <br>Almenos 8 letras y/o digitos, <br>Al menos 1 letra mayúscula, <br>Al menos 1 letra minúscula, <br>Al menos 1 número. <br>(Opcional) Caracteres especiales permitidos: _@#$%^&- ';
        			$err_id .= '<br>Password';
        		}
        		if(!validPass($password) && validConfirm($password, $confirm)){
        			$lbl_msg .= '!#r_conf_div?Las contraseñas no coinciden, verificar.';
        			$err_id .= '<br>Password';
        		}
        		if(validNumero($dterms)){
        			$lbl_msg .= '!#r_reg_div?"';
        			$err_id .= '<br>Formato de Dato Inválido en checkbox "no deseo recibir promociones';
        		}
    
    			echo $err_msg . $lbl_msg;
    		}
		}
		else
		{
		    echo '||-1||#r_reg_div?Aceptar Aviso de Privacidad.';    
		}
	}
	
	/*function exRecovery($email)
	{
		$err_msg = '||-1||#r_forgot_div||Ingresar correo válido';
		
		if(validEmail($email) == 0){

			$utf8_mail = stringFormat($email);
			
			if(!is_null($utf8_mail))
			{
				include_once $_SERVER['DOCUMENT_ROOT'].'/model/usuario.php';

				$usuario = new Usuario();
				$usuario->recuperacion($utf8_mail);
			}
			else
			{
				echo $err_msg;
			}
		}
		else
		{
			echo $err_msg;
		}
	}*/
	function exRecovery($email)
	{
		//$err_msg = '||-1||#r_forgot_div||Ingresar correo válido';
		$err_msg = json_encode(
		    array(
		        "data-desc"=>htmlentities("error_1", ENT_QUOTES, 'utf-8' ), 
		        "data-op"=>htmlentities("-1", ENT_QUOTES, 'utf-8' ), 
		        "data-element"=>htmlentities("#r_forgot_div", ENT_QUOTES, 'utf-8' ), 
		        "data-resp"=>htmlentities("Ingresar correo válido", ENT_QUOTES, 'utf-8' )
	        )
	    );
		
		if(validEmail($email) == 0){

			$utf8_mail = stringFormat($email);
			
			if(!is_null($utf8_mail))
			{
				include_once $_SERVER['DOCUMENT_ROOT'].'/model/usuario.php';

				$usuario = new Usuario();
				$usuario->recuperacion($utf8_mail);
			}
			else
			{
				echo $err_msg;
			}
		}
		else
		{
			echo $err_msg;
		}
	}
	
	/***********************************************************************/
	/***********************************************************************/
	
    function sanitizarEntrada($input_post)
    {
        
        $campos_validos = [
            'controller',
            'email_php',
            'key_php',
            'name',
            'ap_paterno',
            'email',
            'password',
            'confirm',
            'aterms',
            'dterms'
        ];
        $campos_enteros = [
            'aterms',
            'dterms'
        ];
        $campos_email = [
            "email_php",
            "email"
        ];
        
        $sanitized_post = [];
        
        foreach($input_post as $field=>$value)
        {
            if(in_array($field, $campos_validos, FALSE))
            {
                $sanitized_value = htmlentities($value, ENT_QUOTES | ENT_HTML5);
                
                if(in_array($field, $campos_enteros, FALSE))
                    $sanitized_value = (int)$sanitized_value;
                if(in_array($field, $campos_email, FALSE))
                    $sanitized_value = filter_Var($value, FILTER_VALIDATE_EMAIL);
                
                $sanitized_post[$field] = $sanitized_value;
            }
        }
        
        return $sanitized_post;
    }
	
?>
